ALTER TABLE VBR.VET_HEALTH_BENEFIT_PLAN
 DROP PRIMARY KEY CASCADE;

DROP TABLE VBR.VET_HEALTH_BENEFIT_PLAN CASCADE CONSTRAINTS;

CREATE TABLE VBR.VET_HEALTH_BENEFIT_PLAN
(
  VET_BENEFIT_PLAN_ID      NUMBER(20)           NOT NULL,
  DOCUMENT_RECEIPT_ID      NUMBER(20),
  COVERAGE_PLAN_CODE       VARCHAR2(20 BYTE),
  HEALTH_BENEFIT_CODE      VARCHAR2(10 BYTE),
  HEALTH_BENEFIT_CATEGORY  VARCHAR2(100 BYTE),
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE L_VBR_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN VBR.VET_HEALTH_BENEFIT_PLAN.HEALTH_BENEFIT_CATEGORY IS 'Can be Dental, Enrollment, etc. Each of these categories can have sub categories. Each veteran will have multiple categories and each category has an ordered pair of benefit code and coverage code.';

COMMENT ON COLUMN VBR.VET_HEALTH_BENEFIT_PLAN.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN VBR.VET_HEALTH_BENEFIT_PLAN.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN VBR.VET_HEALTH_BENEFIT_PLAN.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN VBR.VET_HEALTH_BENEFIT_PLAN.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN VBR.VET_HEALTH_BENEFIT_PLAN.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';



CREATE INDEX VBR.VHBP_DOCRCP_FK ON VBR.VET_HEALTH_BENEFIT_PLAN
(DOCUMENT_RECEIPT_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX VBR.VHBP_PK ON VBR.VET_HEALTH_BENEFIT_PLAN
(VET_BENEFIT_PLAN_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM VET_HEALTH_BENEFIT_PLAN FOR VBR.VET_HEALTH_BENEFIT_PLAN;


ALTER TABLE VBR.VET_HEALTH_BENEFIT_PLAN ADD (
  CONSTRAINT VHBP_PK
  PRIMARY KEY
  (VET_BENEFIT_PLAN_ID)
  USING INDEX VBR.VHBP_PK
  ENABLE VALIDATE);

ALTER TABLE VBR.VET_HEALTH_BENEFIT_PLAN ADD (
  CONSTRAINT RELATIONSHIP117 
  FOREIGN KEY (DOCUMENT_RECEIPT_ID) 
  REFERENCES VBR.DOCUMENT_RECEIPT (DOCUMENT_RECEIPT_ID)
  ENABLE VALIDATE);

GRANT REFERENCES, SELECT ON VBR.VET_HEALTH_BENEFIT_PLAN TO ADRFILE;

GRANT DELETE ON VBR.VET_HEALTH_BENEFIT_PLAN TO EEUSR;

GRANT SELECT ON VBR.VET_HEALTH_BENEFIT_PLAN TO VBR_R;

GRANT INSERT, SELECT, UPDATE ON VBR.VET_HEALTH_BENEFIT_PLAN TO VBR_RW;
ALTER TABLE VBR.VETERAN_IDENTIFIER_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE VBR.VETERAN_IDENTIFIER_TYPE CASCADE CONSTRAINTS;

CREATE TABLE VBR.VETERAN_IDENTIFIER_TYPE
(
  VETERAN_IDENTIFIER_TYPE_ID  NUMBER(20)        NOT NULL,
  NAME                        VARCHAR2(80 BYTE) NOT NULL,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE S_VBR_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE VBR.VETERAN_IDENTIFIER_TYPE IS 'Type of identifier of the veteran (ex. VPID, or EDI PI).';

COMMENT ON COLUMN VBR.VETERAN_IDENTIFIER_TYPE.NAME IS 'Type of identifier of the veteran (ex. VPID, or EDI PI).';

COMMENT ON COLUMN VBR.VETERAN_IDENTIFIER_TYPE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN VBR.VETERAN_IDENTIFIER_TYPE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN VBR.VETERAN_IDENTIFIER_TYPE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN VBR.VETERAN_IDENTIFIER_TYPE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN VBR.VETERAN_IDENTIFIER_TYPE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';



CREATE UNIQUE INDEX VBR.VETIDTYP_PK ON VBR.VETERAN_IDENTIFIER_TYPE
(VETERAN_IDENTIFIER_TYPE_ID)
LOGGING
TABLESPACE S_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM VETERAN_IDENTIFIER_TYPE FOR VBR.VETERAN_IDENTIFIER_TYPE;


ALTER TABLE VBR.VETERAN_IDENTIFIER_TYPE ADD (
  CONSTRAINT VETIDTYP_PK
  PRIMARY KEY
  (VETERAN_IDENTIFIER_TYPE_ID)
  USING INDEX VBR.VETIDTYP_PK
  ENABLE VALIDATE);

GRANT REFERENCES, SELECT ON VBR.VETERAN_IDENTIFIER_TYPE TO ADRFILE;

GRANT SELECT ON VBR.VETERAN_IDENTIFIER_TYPE TO BIZFLOW_R;

GRANT SELECT ON VBR.VETERAN_IDENTIFIER_TYPE TO VBR_R;

GRANT INSERT, SELECT, UPDATE ON VBR.VETERAN_IDENTIFIER_TYPE TO VBR_RW;

GRANT REFERENCES ON VBR.VETERAN_IDENTIFIER_TYPE TO DNS;
ALTER TABLE VBR.DOCUMENT_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE VBR.DOCUMENT_TYPE CASCADE CONSTRAINTS;

CREATE TABLE VBR.DOCUMENT_TYPE
(
  DOCUMENT_TYPE_ID       NUMBER(20)             NOT NULL,
  NAME                   VARCHAR2(30 BYTE)      NOT NULL,
  DESCRIPTION            VARCHAR2(100 BYTE),
  VERSIONS_KEPT_NUMBER   NUMBER(3),
  FILE_FORMAT            VARCHAR2(10 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_VBR_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE VBR.DOCUMENT_TYPE IS 'Product type of the document. For the benefits handbook, may include the following  Published copy of the Veterans Health Benefits Handbook,  Published copy of the Veterans Health Benefits at a Glance,  Published copy of the Preferred Facility Change Insert,  Published copy of the Health Benefits Insert,  Digital copy of the Veterans Health Benefits Handbook,  Digital copy of the Veterans Benefits at a Glance.';

COMMENT ON COLUMN VBR.DOCUMENT_TYPE.FILE_FORMAT IS 'PDF or other format';

COMMENT ON COLUMN VBR.DOCUMENT_TYPE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN VBR.DOCUMENT_TYPE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN VBR.DOCUMENT_TYPE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN VBR.DOCUMENT_TYPE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN VBR.DOCUMENT_TYPE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';



CREATE UNIQUE INDEX VBR.DOCTYP_PK ON VBR.DOCUMENT_TYPE
(DOCUMENT_TYPE_ID)
LOGGING
TABLESPACE S_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM DOCUMENT_TYPE FOR VBR.DOCUMENT_TYPE;


ALTER TABLE VBR.DOCUMENT_TYPE ADD (
  CONSTRAINT DOCTYP_PK
  PRIMARY KEY
  (DOCUMENT_TYPE_ID)
  USING INDEX VBR.DOCTYP_PK
  ENABLE VALIDATE);

GRANT REFERENCES, SELECT ON VBR.DOCUMENT_TYPE TO ADRFILE;

GRANT SELECT ON VBR.DOCUMENT_TYPE TO VBR_R;

GRANT INSERT, SELECT, UPDATE ON VBR.DOCUMENT_TYPE TO VBR_RW;
ALTER TABLE VBR.DOCUMENT_RECEIPT
 DROP PRIMARY KEY CASCADE;

DROP TABLE VBR.DOCUMENT_RECEIPT CASCADE CONSTRAINTS;

CREATE TABLE VBR.DOCUMENT_RECEIPT
(
  DOCUMENT_RECEIPT_ID         NUMBER(20)        NOT NULL,
  VETERAN_IDENTIFIER_TYPE_ID  NUMBER(20),
  VETERAN_ID                  VARCHAR2(30 BYTE) NOT NULL,
  RECEIPT_STRING              VARCHAR2(20 BYTE),
  RELEASE_CONTROL_NUMBER      VARCHAR2(20 BYTE),
  RECEIPT_DATE                DATE,
  VERSION_NUMBER              NUMBER(3),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE L_VBR_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE VBR.DOCUMENT_RECEIPT IS 'Record receipt of the document.';

COMMENT ON COLUMN VBR.DOCUMENT_RECEIPT.VETERAN_ID IS 'VPID, or EDI PI';

COMMENT ON COLUMN VBR.DOCUMENT_RECEIPT.RELEASE_CONTROL_NUMBER IS 'Published version of the document. Reflecting rules the document was created under. Synonym for Communications ID. Controls which release of the Veterans Health Benefits Handbook is being generated.  This will allow the Members Benefits Division to control a refresh of the Veterans Health Benefits Handbook when changes occur to the content. For example, changes to the content due to new regulations require Veterans  to be notified.  The actor  will enter a new Release Control Number in order to publish the new Veterans Health Benefits Handbooks. The Release Control Number will also be used for New Enrollees in order to provide the  identification for which Veterans Health Benefits Handbook the veteran received';

COMMENT ON COLUMN VBR.DOCUMENT_RECEIPT.VERSION_NUMBER IS 'Version of the document. ';

COMMENT ON COLUMN VBR.DOCUMENT_RECEIPT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN VBR.DOCUMENT_RECEIPT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN VBR.DOCUMENT_RECEIPT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN VBR.DOCUMENT_RECEIPT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN VBR.DOCUMENT_RECEIPT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';



CREATE UNIQUE INDEX VBR.DOCRCP_PK ON VBR.DOCUMENT_RECEIPT
(DOCUMENT_RECEIPT_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX VBR.DOCRCP_VETIDTYP_FK ON VBR.DOCUMENT_RECEIPT
(VETERAN_IDENTIFIER_TYPE_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX VBR.DOCRCP_VET_NU_I ON VBR.DOCUMENT_RECEIPT
(VETERAN_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM DOCUMENT_RECEIPT FOR VBR.DOCUMENT_RECEIPT;


ALTER TABLE VBR.DOCUMENT_RECEIPT ADD (
  CONSTRAINT DOCRCP_PK
  PRIMARY KEY
  (DOCUMENT_RECEIPT_ID)
  USING INDEX VBR.DOCRCP_PK
  ENABLE VALIDATE);

ALTER TABLE VBR.DOCUMENT_RECEIPT ADD (
  CONSTRAINT RELATIONSHIP96 
  FOREIGN KEY (VETERAN_IDENTIFIER_TYPE_ID) 
  REFERENCES VBR.VETERAN_IDENTIFIER_TYPE (VETERAN_IDENTIFIER_TYPE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON VBR.DOCUMENT_RECEIPT TO ADR;

GRANT REFERENCES, SELECT ON VBR.DOCUMENT_RECEIPT TO ADRFILE;

GRANT DELETE ON VBR.DOCUMENT_RECEIPT TO EEUSR;

GRANT SELECT ON VBR.DOCUMENT_RECEIPT TO VBR_R;

GRANT INSERT, SELECT, UPDATE ON VBR.DOCUMENT_RECEIPT TO VBR_RW;
ALTER TABLE VBR.DOCUMENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE VBR.DOCUMENT CASCADE CONSTRAINTS;

CREATE TABLE VBR.DOCUMENT
(
  DOCUMENT_ID            NUMBER(20)             NOT NULL,
  DOCUMENT_TYPE_ID       NUMBER(20)             NOT NULL,
  DOCUMENT_RECEIPT_ID    NUMBER(20),
  FILE_ID                NUMBER(20),
  CREATION_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE L_VBR_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE VBR.DOCUMENT IS 'Documents in digital form.  For example, a catalog of Veterans Benefit Handbooks.';

COMMENT ON COLUMN VBR.DOCUMENT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN VBR.DOCUMENT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN VBR.DOCUMENT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN VBR.DOCUMENT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN VBR.DOCUMENT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';



CREATE INDEX VBR.DOC_DOCRCP_FK ON VBR.DOCUMENT
(DOCUMENT_RECEIPT_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX VBR.DOC_DOCTYP_FK ON VBR.DOCUMENT
(DOCUMENT_TYPE_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX VBR.DOC_FLE_FK ON VBR.DOCUMENT
(FILE_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX VBR.DOC_PK ON VBR.DOCUMENT
(DOCUMENT_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM DOCUMENT FOR VBR.DOCUMENT;


ALTER TABLE VBR.DOCUMENT ADD (
  CONSTRAINT DOC_PK
  PRIMARY KEY
  (DOCUMENT_ID)
  USING INDEX VBR.DOC_PK
  ENABLE VALIDATE);

ALTER TABLE VBR.DOCUMENT ADD (
  CONSTRAINT HANDBOOK_PRODUCT_TYPE_FK 
  FOREIGN KEY (DOCUMENT_TYPE_ID) 
  REFERENCES VBR.DOCUMENT_TYPE (DOCUMENT_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT RELATIONSHIP116 
  FOREIGN KEY (FILE_ID) 
  REFERENCES ADRFILE.FILES (FILE_ID)
  ENABLE VALIDATE,
  CONSTRAINT RELATIONSHIP89 
  FOREIGN KEY (DOCUMENT_RECEIPT_ID) 
  REFERENCES VBR.DOCUMENT_RECEIPT (DOCUMENT_RECEIPT_ID)
  ENABLE VALIDATE);

GRANT SELECT ON VBR.DOCUMENT TO ADR;

GRANT REFERENCES, SELECT ON VBR.DOCUMENT TO ADRFILE;

GRANT DELETE ON VBR.DOCUMENT TO EEUSR;

GRANT SELECT ON VBR.DOCUMENT TO VBR_R;

GRANT INSERT, SELECT, UPDATE ON VBR.DOCUMENT TO VBR_RW;
